﻿Option Strict On
Option Explicit On
Option Infer On

Public Class Form1

    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click
        'pobieranie danych z tabeli
        Dim bazaDanychTelefony As TelefonyDataContext = New TelefonyDataContext()
        'Dim listaOsob As System.Data.Linq.Table(Of ListaOsob) = bazaDanychTelefony.ListaOsobs
        Dim [listaOsob] = bazaDanychTelefony.ListaOsobs

        'pobieranie kolekcji
        Dim listaOsobPelnoletnich = From osoba In [listaOsob] Where osoba.Wiek >= 18 Select osoba

        'wyświetlanie pobranej kolekcji
        Dim s As String = "Lista osób pełnoletnich:" & vbNewLine
        For Each osoba As ListaOsob In listaOsobPelnoletnich
            s &= osoba.Imię & " " & osoba.Nazwisko & " (" & osoba.Wiek & ")" & vbNewLine
        Next
        MessageBox.Show(s)

        'informacje o pobranych danych
        MessageBox.Show("Typ: " & listaOsobPelnoletnich.GetType().FullName)
        MessageBox.Show("Ilość pobranych rekordów: " & listaOsobPelnoletnich.Count().ToString())
        MessageBox.Show("Suma wieku wybranych osób: " _
            & listaOsobPelnoletnich.Sum(Function(osoba) osoba.Wiek).ToString())
        MessageBox.Show("Imię pierwszej osoby: " & listaOsobPelnoletnich.First().Imię)

        s = "Pełna lista osób:" & vbNewLine
        For Each osoba As ListaOsob In [listaOsob]
            s &= osoba.Imię & " " & osoba.Nazwisko & " (" & osoba.Wiek & ")" & vbNewLine
        Next
        
        MessageBox.Show(s)
    End Sub

    Public Sub New()
        InitializeComponent()

        Dim drugaForma As Form2 = New Form2() : drugaForma.Show()
        Dim trzeciaForma As Form3 = New Form3() : trzeciaForma.Show()
    End Sub

    Private Sub ZamknijButton_Click(sender As System.Object, e As System.EventArgs) Handles ZamknijButton.Click
        Close()
    End Sub

    Dim bazaDanychTelefony As TelefonyDataContext = New TelefonyDataContext()

    Private Sub Button2_Click(sender As System.Object, e As System.EventArgs) Handles Button2.Click
        Dim listaOsob = bazaDanychTelefony.ListaOsobs
        Dim rozmowy = bazaDanychTelefony.Rozmowies

        Dim listaDlugichRozmow As IEnumerable(Of String) = _
            From osoba In listaOsob
            Join rozmowa In rozmowy On osoba.Id Equals rozmowa.Id
            Where rozmowa.CzasTrwania > 10
            Select osoba.Imię & " " & osoba.Nazwisko & ", " & rozmowa.Data.ToString() & " (" & rozmowa.CzasTrwania & ")"

        Dim s As String = "Lista rozmów trwających dłużej niż 10 min:" & vbNewLine
        For Each opis As String In listaDlugichRozmow
            s &= opis & vbNewLine
        Next

        MessageBox.Show(s)
    End Sub

    Private Sub Button3_Click(sender As System.Object, e As System.EventArgs) Handles Button3.Click
        Dim rozmowy = bazaDanychTelefony.Rozmowies

        Dim listaDlugichRozmow = _
            From rozmowa In rozmowy
            Where rozmowa.CzasTrwania > 10
            Select rozmowa.ListaOsob.Imię & " " &
                                rozmowa.ListaOsob.Nazwisko & ", " &
                                rozmowa.Data.ToString() &
                                " (" & rozmowa.CzasTrwania & ")"

        Dim s As String = "Lista rozmów trwających dłużej niż 10 min:" & vbNewLine
        For Each opis As String In listaDlugichRozmow
            s &= opis & vbNewLine
        Next
        MessageBox.Show(s)

        'filtrowanie
        Dim listaRozmowBobaParra = _
            bazaDanychTelefony.ListaOsobs.Single(Function(osoba) osoba.Id = 1).Rozmowies

        s = "Lista rozmówca Boba Parra:" & vbNewLine
        For Each rozmowa As Rozmowy In listaRozmowBobaParra
            s &= rozmowa.Rozmowca & vbNewLine
        Next
        MessageBox.Show(s)

        Dim listaRozmowBobaParra2 = _
            From rozmowa In rozmowy
            Where rozmowa.Id = 1
            Select rozmowa

        s = "Lista rozmówca Boba Parra:" & vbNewLine
        For Each rozmowa As Rozmowy In listaRozmowBobaParra
            s &= rozmowa.Rozmowca & vbNewLine
        Next
        MessageBox.Show(s)
    End Sub

    Private Sub Button4_Click(sender As System.Object, e As System.EventArgs) Handles Button4.Click
        Dim listaOsobPelnoletnich As IEnumerable(Of ListaOsobPelnoletnichResult) = _
            bazaDanychTelefony.ListaOsobPelnoletnich()

        Dim s As String = "Lista osób pełnoletnich (procedura składowana):" & vbNewLine
        For Each osoba In listaOsobPelnoletnich
            s &= osoba.Imię & " " & osoba.Nazwisko & " (" & osoba.Wiek & ")" & vbNewLine
        Next
        MessageBox.Show(s)
    End Sub

    Private Sub Button5_Click(sender As System.Object, e As System.EventArgs) Handles Button5.Click
        bazaDanychTelefony.AktualizujWiek()
    End Sub
End Class
